IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO](
	[CD_EMP] [int] NOT NULL,
	[CD_PROD] [int] NOT NULL,
	[DT_CAD] [datetime] NOT NULL,
	[CD_CTR] [int] NOT NULL,
	[DT_CAD_CONFIRMACAO] [datetime] NOT NULL,
 CONSTRAINT [PK_EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO] PRIMARY KEY CLUSTERED 
(
	[CD_CTR] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO] ADD  CONSTRAINT [DF_EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO] ADD  CONSTRAINT [DF_EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO_CD_PROD]  DEFAULT ((0)) FOR [CD_PROD]

ALTER TABLE [dbo].[EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO] ADD  CONSTRAINT [DF_EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO_CD_CTR]  DEFAULT ((0)) FOR [CD_CTR]

ALTER TABLE [dbo].[EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO] ADD  CONSTRAINT [DF_EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO_DT_CAD_CONFIRMACAO]  DEFAULT (getdate()) FOR [DT_CAD_CONFIRMACAO]

ALTER TABLE [dbo].[EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO]  WITH CHECK ADD  CONSTRAINT [FK_EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO_EST_PROD] FOREIGN KEY([CD_EMP], [CD_PROD])
REFERENCES [dbo].[EST_PROD] ([CD_EMP], [CD_PROD])

ALTER TABLE [dbo].[EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO] CHECK CONSTRAINT [FK_EST_PROD_INTEGRACAO_CONFIRMACAO_RECBTO_EST_PROD]
end

